#include "fpga_shared.h"

/*
 All call to external libraries are removed from the original lame source code
 and moved to FPGA_SHARED_LIBS file
*/

//LAME and PGP shared functions
void fpga_assert(exp)
{
	_fpga_assert(exp);
}

int fpga_setmode(int file_no, int mode)
{
	return setmode(file_no, mode);
}

void fpga_abort()
{
	abort();
}

int fpga_abs(int num)
{
	return abs(num);
}

double fpga_atof(const char *str)
{
	return atof(str);
}

int fpga_atoi(const char *str)
{
	return atoi(str);
}

void *fpga_calloc(size_t num, size_t size)
{
	return calloc(num, size);
}

clock_t fpga_clock()
{
	return clock();
}

double fpga_cos(double num)
{
	return cos(num);
}

double fpga_difftime(time_t time2, time_t time1)
{
	return difftime(time2, time1);
}

void fpga_exit(int exit_code)
{
	exit(exit_code);
}

double fpga_exp(double arg)
{
	return exp(arg);
}

double fpga_fabs(double num)
{
	return fabs(num);
}

int fpga_fclose(FILE *stream)
{
	return fclose(stream);
}

int fpga_fflush(FILE *stream)
{
	return fflush(stream);
}

double fpga_floor(double num)
{
	return floor(num);
}

FILE *fpga_fopen(const char *fname, const char *mode)
{
	return fopen(fname,mode);
}

int fpga_fprintf(FILE *stream, const char *format,...)
{
	int chars_written = 0;
	va_list var_args;
	va_start(var_args, format);
	chars_written = vfprintf(stream, format,var_args);
	va_end(var_args);
	return chars_written;
}

int fpga_vfprintf(FILE *stream, const char *format, va_list args)
{
	return vfprintf(stream, format,args);
}

size_t fpga_fread(void *buf, size_t size, size_t count, FILE *stream)
{
	return fread(buf, size, count, stream);
}

void fpga_free(void *ptr)
{
	free(ptr);
}

double fpga_frexp(double num, int *exp)
{
	return frexp(num, exp);
}

int fpga_fseek(FILE *stream, long offset, int origin)
{
	return fseek(stream, offset, origin);
}

long fpga_ftell(FILE *stream)
{
	return ftell(stream);
}

size_t fpga_fwrite(const void *buf, size_t size, size_t count, FILE *stream)
{
	return fwrite(buf, size, count, stream);
}

double fpga_ldexp(double num, int exp)
{
	return ldexp(num, exp);
}

double fpga_log(double num)
{
	return log(num);
}

double fpga_log10(double num)
{
	return log10(num);
}

void *fpga_malloc(size_t size)
{
	return malloc(size);
}

void *fpga_memcpy(void *to, const void *from, size_t count)
{
	return memcpy(to,from,count);
}

void *fpga_memset(void *buf, int ch, size_t count)
{
	return memset(buf, ch, count);
}

double fpga_pow(double base, double exp)
{
	return pow(base, exp);
}

void *fpga_realloc(void *ptr, size_t size)
{
	return realloc(ptr, size);
}

double fpga_sin(double arg)
{
	return sin(arg);
}

double fpga_sqrt(double num)
{
	return sqrt(num);
}

int fpga_stat(const char* file_name, struct stat* status)
{
	return stat(file_name, status);
}

int fpga_strcmp(const char *str1, const char *str2)
{
	return strcmp(str1, str2);
}

char *fpga_strcpy(char *str1, const char *str2)
{
	return strcpy(str1, str2);
}

size_t fpga_strlen(const char *str1)
{
	return strlen(str1);
}

char *fpga_strncat(char *str1, const char *str2, size_t count)
{
	return strncat(str1, str2, count);
}

char *fpga_strncpy(char *str1, const char *str2, size_t count)
{
	return strncpy(str1, str2, count);
}

long fpga_strtol(const char *start, char **end, int radix)
{
	return strtol(start, end, radix);
}

double fpga_tan(double arg)
{
	return tan(arg);
}

double	 fpga_atan2(double arg1, double arg2)
{
	return atan2(arg1,arg2);
}

time_t fpga_time(time_t *current_time)
{
	return time(current_time);
}

int fpga_fputc(int num, FILE *stream)
{
	return fputc(num, stream);
}

int fpga_fputs(const char* text, FILE *stream)
{
	return fputs(text, stream);
}

int fpga_getc(FILE *stream)
{
	return getc(stream);
}

FILE* fpga_stderr(void)
{
	return stderr;
}

FILE* fpga_stdout(void)
{
	return stdout;
}

FILE* fpga_stdin(void)
{
	return stdin;
}

int fpga_fileno(FILE *stream)
{
	return fileno(stream);
}

int fpga_sprintf(char *buf, const char *format,...)
{
	int chars_written = 0;
	va_list var_args;
	va_start(var_args, format);
	chars_written = vsprintf(buf, format, var_args);
	va_end(var_args);
	return chars_written;
}

int fpga_printf( const char *format, ... )
{
	int chars_written = 0;
	va_list var_args;
	va_start(var_args, format);
	chars_written = vprintf(format, var_args);
	va_end(var_args);
	return chars_written;
}

//******************************************************************
//LAME functions
double fpga_atan(double arg)
{
	return atan(arg);
}

void fpga_srand(unsigned int seed)
{
	srand(seed);
}

int fpga__setmode(int file_no, int mode)
{
	return setmode(file_no, mode);
}

int fpga_putc(int num, FILE *stream)
{
	return putc( num , stream);
}

double fpga_HUGE_VAL(void)
{
	return HUGE_VAL;
}

int fpga_feof(FILE *stream)
{
	return feof(stream);
}

int fpga_ferror(FILE *stream)
{
	return ferror(stream);
}

int fpga__fileno(FILE *stream)
{
	return _fileno(stream);
}

int fpga__controlfp(unsigned int num1,unsigned int num2)
{
	return _controlfp(num1,num2);
}

void fpga__ftime (struct _timeb* t )
{
	_ftime (t);
}

//******************************************************************
//PGP functions
int fpga_remove( const char *path )
{
	return remove( path );
}

int fpga_strncmp( const char *string1, const char *string2, size_t count )
{
	return strncmp ( string1, string2, count );
}

void fpga_rewind( FILE *stream )
{
	rewind( stream );
}

int fpga_ungetc( int c, FILE *stream )
{
	return ungetc( c, stream );
}

int fpga_sscanf( const char *buffer, const char *format, ... )
{
	va_list var_args;
	va_start(var_args, format);
	return sscanf( buffer, format, var_args );
	va_end(var_args);
}

int fpga_toupper( int c )
{
	return toupper( c );
}

int fpga_tolower( int c )
{
	return tolower( c );
}

void fpga_perror( const char *string )
{
	perror( string );
}

int fpga_access( const char *path, int mode )
{
	return access( path, mode );
}

char *fpga_strrchr( const char *string, int c )
{
	return strrchr( string, c );
}

char *fpga_getenv( const char *varname )
{
	return getenv( varname );
}

char *fpga_strchr( const char *string, int c )
{
	return strchr( string, c );
}

int fpga_rename( const char *oldname, const char *newname )
{
	return rename( oldname, newname );
}

size_t fpga_strspn( const char *string, const char *strCharSet )
{
	return strspn( string, strCharSet );
}

int fpga_getch( void )
{
	return getch();
}

int fpga_kbhit( void )
{
	return kbhit();
}

int fpga_fgetc( FILE *stream )
{
	return fgetc( stream );
}

int fpga_system( const char *command )
{
	return system( command );
}

long fpga_atol( const char *string )
{
	return atol( string );
}

int fpga_read( int handle, void *buffer, unsigned int count )
{
	return read( handle, buffer, count );
}

char *fpga_fgets( char *string, int n, FILE *stream )
{
	return fgets( string, n, stream );
}

int fpga_write( int handle, const void *buffer, unsigned int count )
{
	return write( handle, buffer, count );
}

long fpga_lseek( int handle, long offset, int origin )
{
	return lseek( handle, offset, origin );
}

int	fpga_zputc( int c, FILE *stream )
{
	return putc( c, stream );
}

int fpga_putchar( int c )
{
	return putchar( c );
}

int fpga_isalnum( int c )
{
	return isalnum( c );
}

int fpga_isspace( int c )
{
	return isspace( c );
}

int fpga_isdigit( int c )
{
	return isdigit( c );
}

int fpga_isalpha( int c )
{
	return isalpha( c );
}

int fpga_islower( int c )
{
	return islower( c );
}

int fpga_isupper( int c )
{
	return isupper( c );
}

void fpga_errno( int no )
{
	errno = no;
}

void fpga_sleep( unsigned long sleepTime )
{
	_sleep( sleepTime );
}

int fpga_signal( int sig, void *func)
{

}

//END of file