#ifndef FPGA_SHARED_LIBS
#define FPGA_SHARED_LIBS

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <math.h>
#include <time.h> //Correct
#include <string.h>
#include <io.h>
//**************** NEW ENTRY ****************
#include <stddef.h>
//#ifdef WIN32
	#include <stdarg.h>
//#else
//	#include <varargs.h>

//#endif
#include <sys/stat.h>
#include <sys/types.h>
//**************** NEW ENTRY ****************
#include <timeb.h>
#include <fcntl.h>
#include <limits.h>
#include <errno.h>
#include <ctype.h>
#include <signal.h>
#include <float.h>
/* #include <conio.h>
#include <iostream.h> */

/* Variable argument passing library */

#define _fpga_assert(exp)	assert(exp)

/*
 All call to external libraries are removed from the original lame source code
 and moved to FPGA_SHARED_LIBS file
*/

//LAME and PGP shared functions
//void     fpga_assert(exp);
int      fpga_setmode(int file_no, int mode);
void     fpga_abort(); // no occurrences
int      fpga_abs(int num); // no occurrences
double   fpga_atof(const char *str);
int      fpga_atoi(const char *str);
void    *fpga_calloc(size_t num, size_t size); // no occurrences
clock_t  fpga_clock();
double   fpga_cos(double num);
double   fpga_difftime(time_t time2, time_t time1);
void     fpga_exit(int exit_code);
double   fpga_exp(double arg);
double   fpga_fabs(double num);
int      fpga_fclose(FILE *stream);
int      fpga_fflush(FILE *stream);
double   fpga_floor(double num);
FILE    *fpga_fopen(const char *fname, const char *mode);
int      fpga_fprintf(FILE *stream, const char *format,...);
int		 fpga_vfprintf(FILE *stream, const char *format, va_list args); //Problem the MACROS
size_t   fpga_fread(void *buf, size_t size, size_t count, FILE *stream);
void     fpga_free(void *ptr);
double   fpga_frexp(double num, int *exp);
int      fpga_fseek(FILE *stream, long offset, int origin);
long     fpga_ftell(FILE *stream);
size_t   fpga_fwrite(const void *buf, size_t size, size_t count, FILE *stream);
double   fpga_ldexp(double num, int exp);
double   fpga_log(double num);
double   fpga_log10(double num);
void    *fpga_malloc(size_t size);
void    *fpga_memcpy(void *to, const void *from, size_t count);
void    *fpga_memset(void *buf, int ch, size_t count);
double   fpga_pow(double base, double exp);
void    *fpga_realloc(void *ptr, size_t size);
double   fpga_sin(double arg);
double   fpga_sqrt(double num);
int      fpga_stat(const char* file_name, struct stat* status);
int      fpga_strcmp(const char *str1, const char *str2);
char    *fpga_strcpy(char *str1, const char *str2);
size_t   fpga_strlen(const char *str1);
char    *fpga_strncat(char *str1, const char *str2, size_t count);
char    *fpga_strncpy(char *str1, const char *str2, size_t count);
long     fpga_strtol(const char *start, char **end, int radix);
double   fpga_tan(double arg);
double	 fpga_atan2(double arg1, double arg2);
time_t   fpga_time(time_t *current_time);
int		 fpga_fputc(int num, FILE *stream);
int		 fpga_fputs(const char* text, FILE *stream);
int		 fpga_getc(FILE *stream);
FILE*	 fpga_stderr(void); //setbuf
FILE*	 fpga_stdout(void);
FILE*	 fpga_stdin(void);
int		 fpga_fileno(FILE *stream);
int      fpga_sprintf(char *buf, const char *format,...);
int      fpga_printf(const char *format,...);


//Lame functions
double   fpga_atan(double arg);
int      fpga__setmode(int file_no, int mode);
void     fpga_srand(unsigned int seed);
int		 fpga_putc(int num, FILE *stream);
double	 fpga_HUGE_VAL(void);
int		 fpga_feof(FILE *stream);
int		 fpga_ferror(FILE *stream);
int		 fpga__fileno(FILE *stream);
int		 fpga__controlfp(unsigned int num1,unsigned int num2);
//void     fpga__ftime(struct _timeb* t);

//PGP functions//***************************************************
int      fpga_remove( const char *path );
//LAME and FPGA//***************************************************
int      fpga_strncmp( const char *string1, const char *string2, size_t count );
//END END END LAME and FPGA//***************************************
void     fpga_rewind( FILE *stream );
int      fpga_ungetc( int c, FILE *stream );
int		 fpga_sscanf( const char *buffer, const char *format, ... );
int      fpga_toupper( int c );
int      fpga_tolower( int c );
//LAME and FPGA//***************************************************
void     fpga_perror( const char *string );
//END END END LAME and FPGA//***************************************
int      fpga_access( const char *path, int mode );
char     *fpga_strrchr( const char *string, int c );
//LAME and FPGA//***************************************************
char	 *fpga_getenv( const char *varname );
char	 *fpga_strchr( const char *string, int c );
//END END END LAME and FPGA//***************************************
int		 fpga_rename( const char *oldname, const char *newname );
size_t   fpga_strspn( const char *string, const char *strCharSet );
int		 fpga_getch( void );
int		 fpga_kbhit( void );
int		 fpga_fgetc( FILE *stream );
int		 fpga_system( const char *command );
long	 fpga_atol( const char *string );
int		 fpga_read( int handle, void *buffer, unsigned int count );
char	 *fpga_fgets( char *string, int n, FILE *stream );
int		 fpga_write( int handle, const void *buffer, unsigned int count );
long	 fpga_lseek( int handle, long offset, int origin );
int		 fpga_zputc( int c, FILE *stream );
int		 fpga_putchar( int c );
int		 fpga_isalnum( int c );
int		 fpga_isspace( int c );
int		 fpga_isdigit( int c );
int		 fpga_isalpha( int c );
int		 fpga_islower( int c );
int		 fpga_isupper( int c );
void	 fpga_errno( int no );
void 	 fpga_sleep( unsigned long sleepTime );
int 	 fpga_signal( int sig, void *func );

#endif